require 'webrick'

class WebServer < WEBrick::HTTPServlet::AbstractServlet
  def do_GET(request, response)
    handlers = Handlers.new
    status_code, content_type, body = handlers.handle(request.path)

    response.status = status_code
    response['Content-Type'] = content_type
    response.body = body
  end
end

class Handlers
  def handle(path)
    case path
    when "/"
      [200, 'text/plain', 'Witaj, świecie']
    when "/api"
      [201, 'application/json', '{"foo":"bar"}']
    else
      [404, 'text/plain', 'Nie znaleziono']
    end
  end
end

# Ten kod będzie działał tylko po uruchomieniu skryptu bezpośrednio z poziomu
# CLI, ale nie w sytuacji, gdy będzie żądany z poziomu innego pliku.
if __FILE__ == $0
  # Uruchomienie serwera w komputerze lokalnym i nasłuchującego na porcie 8000.
  server = WEBrick::HTTPServer.new :Port => 8000
  server.mount '/', WebServer

  # Zakończenie działania serwera następuje po naciśnięciu klawiszy Ctrl+C.
  trap 'INT' do server.shutdown end

  # Uruchomienie serwera.
  server.start
end
